 ; Ŀ
 ;   Ground - insert a block on a the end of a line.                       
 ;   Copyright 1999, 2010 by Rocket Software Ltd.                          
 ;   Women are Animals.  Strictly in a zoological sense.                   
 ; 

 ; Ŀ
 ;   Soole - error handler.                                                
 ; 
 (DEFUN SOOLE (shk / pos entt enam sublst vall)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Soole end.                                                            
 ; 

 ; Ŀ
 ;   Ssins.                                                                
 ; 
 (DEFUN C:GROUND (/ esav *error* scal pa pb ss enam entt ten elv angg)
  (setvar "cmdecho" 0)
  (setq esav *error*)
  (setq *error* soole)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
  (setq pa (getpoint "Line: "))
  (if (setq pb (osnap pa "near"))                  ; look for a near point
      (setq pa pb))                                ; if one then use it
 ; Ŀ
 ;   Decide which type of entity we are dealing with.                      
 ; 
  (cond ((setq ss (ssget pa (list (cons 0 "line"))))
         (setq enam (ssname ss 0))
         (setq entt (entget enam))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (if (<= (distance pa ten) (distance pa elv))
             (progn
                  (setq pa ten)
                  (setq angg (angle elv ten)))
             (progn
                  (setq pa elv)
                  (setq angg (angle ten elv))))
         (setq angg (+ (/ (* angg 180) pi) 90))
         (command "insert" "ground" pa scal "" angg))
        ((setq ss (ssget pa '((-4 . "<or") (0 . "polyline")
                              (0 . "lwpolyline") (-4 . "or>"))))
         (setq pb (osnap pa "end"))
         (if (equal pa pb) (setq pa (osnap pa "mid")))
         (setq angg (angle pa pb))
         (setq angg (+ (/ (* angg 180) pi) 90))
         (command "insert" "ground" pb scal "" angg))
      (t (command "insert" "ground" pa scal "" 0)))
  (setq *error* esav)
 (princ))